<?php
/**
 * Veidotājs: Roberts Blite
 * Mērķis: Šis PHP skripts apstrādā lietotāja pieslēgšanās procesu.
 * Apraksts: Skripts saņem lietotāja e-pastu un paroli, pārbauda tos datubāzē un,
 *           ja autentifikācija ir veiksmīga, izveido sesiju un pāradresē uz galveno lapu.
 */

// Datubāzes savienojuma parametri
$servername = "database-1.cd0m46mqkm83.eu-north-1.rds.amazonaws.com";
$username = "admin";
$password = "HyperX3146!";
$dbname = "rb_kvalif_410";

// Izveido savienojumu ar datubāzi
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbauda, vai savienojums izveidots veiksmīgi
if ($conn->connect_error) {
    die("Savienojums neizdevās: " . $conn->connect_error);
}

// Sāk sesiju, lai pārvaldītu lietotāja sesijas statusu
session_start();

// Notīra esošos sesijas datus, lai izvairītos no iespējamām drošības problēmām
session_unset();
session_destroy();
session_start();

$error_message = ''; // Iniciē kļūdas ziņojumu

// Pārbauda, vai forma ir iesniegta, izmantojot POST metodi
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $email = trim($_POST['email'] ?? ''); // Attīra ievadīto e-pasta adresi
    $password = trim($_POST['password'] ?? ''); // Attīra ievadīto paroli

    // Pārbauda, vai abi lauki ir aizpildīti
    if (!empty($email) && !empty($password)) {
        // Izmanto sagatavotu SQL vaicājumu, lai novērstu SQL injekcijas
        $sql = "SELECT * FROM rb_kvalif_signup_410 WHERE email = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();

        // Pārbauda, vai lietotājs eksistē
        if ($result->num_rows === 1) {
            $user = $result->fetch_assoc();

            // Pārbauda, vai parole ir pareiza (salīdzina ar hash)
            if (password_verify($password, $user['password'])) {
                // Uzstāda sesijas mainīgos
                $_SESSION['logged_in'] = true;
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_email'] = $user['email'];
                $_SESSION['first_name'] = $user['first_name'];
                $_SESSION['work_position'] = $user['work_position'];

                // Pāradresē uz galveno lapu pēc veiksmīgas autentifikācijas
                header("Location: ../php/main.php");
                exit();
            } else {
                // Kļūdas ziņojums, ja parole nav pareiza
                $error_message = "Nepareizs e-pasts vai parole.";
            }
        } else {
            // Kļūdas ziņojums, ja lietotājs netika atrasts
            $error_message = "Nepareizs e-pasts vai parole.";
        }
        $stmt->close();
    } else {
        // Kļūdas ziņojums, ja kāds no laukiem ir tukšs
        $error_message = "Lūdzu, aizpildiet visus laukus.";
    }
}

// Aizver savienojumu ar datubāzi
$conn->close();

// Iekļauj pieslēgšanās lapu, lai parādītu kļūdas ziņojumu, ja tāds ir
include '../html/index.html';
?>
